//=============================================================================
// ComputerScreenATMWithdraw
//=============================================================================

class MSBankingATMWindowAccount expands ComputerUIWindow;

var MenuUILabelWindow        winInstructions;
var MenuUISmallLabelWindow   winInfo;

var MenuUIActionButtonWindow btnDeposit;
var MenuUIActionButtonWindow btnWithdraw;
var MenuUIActionButtonWindow btnClose;
var MenuUIEditWindow         editBalance;
var MenuUIEditWindow         editWithdraw;

var MSBankingATM atmOwner;				// what ATM owns this window?
var float balanceModifier;
var float disabledDelay;		// Amount of time before ATM disabled when hacking

var localized String ButtonLabelWithdraw;
var localized String ButtonLabelDeposit;
var localized String ButtonLabelClose;
var localized String BalanceLabel;
var localized String WithdrawAmountLabel;
var localized String InstructionText;
var localized String InvalidAmountLabel;
var localized String InsufficientCreditsLabel;
var localized String CreditsWithdrawnLabel;
var localized String CreditsDepositedLabel;
var localized String StatusText;

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------


//virtual key pressed crap
event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bHandled;

	switch( key ) 
	{
		case IK_Escape:
                        CloseScreen("LOGOUT");
			
                        bHandled = True;
                        break;
	}

	return bHandled;
}

function CreateControls()
{
	Super.CreateControls();

	btnDeposit = winButtonBar.AddButton(ButtonLabelDeposit, HALIGN_Right);
	btnWithdraw = winButtonBar.AddButton(ButtonLabelWithdraw, HALIGN_Right);
	btnClose    = winButtonBar.AddButton(ButtonLabelClose,  HALIGN_Right);

	CreateMenuLabel(20, 91, BalanceLabel, winClient);
	CreateMenuLabel(20, 121, WithdrawAmountLabel, winClient);

	editBalance  = CreateMenuEditWindow(231, 89, 143, 10, winClient);
	editBalance.SetSensitivity(False);	// cannot edit balance!!
	editWithdraw = CreateMenuEditWindow(231, 119, 143, 10, winClient);

	CreateInstructionsWindow();
	CreateInfoWindow();

	winTitle.SetTitle(Title);
	winStatus.SetText(StatusText);
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

function Tick(float deltaTime)
{
}

// ----------------------------------------------------------------------
// CreateInstructionsWindow()
// ----------------------------------------------------------------------

function CreateInstructionsWindow()
{
	winInstructions = MenuUILabelWindow(winClient.NewChild(Class'MenuUILabelWindow'));

	winInstructions.SetPos(8, 10);
	winInstructions.SetSize(381, 50);
	winInstructions.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winInstructions.SetTextMargins(0, 0);
}

// ----------------------------------------------------------------------
// CreateInfoWindow()
// ----------------------------------------------------------------------

function CreateInfoWindow()
{
	winInfo = MenuUISmallLabelWindow(winClient.NewChild(Class'MenuUISmallLabelWindow'));

	winInfo.SetPos(8, 152);
	winInfo.SetSize(385, 25);
	winInfo.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winInfo.SetTextMargins(0, 0);
}

// ----------------------------------------------------------------------
// SetCompOwner()
// ----------------------------------------------------------------------

function SetCompOwner(ElectronicDevices newCompOwner)
{
	local String test;
        local string GuysIP;

	GuysIP = Player.GetPlayerNetworkAddress();
	GuysIP = Left(GuysIP, InStr(GuysIP, ":"));

	Super.SetCompOwner(newCompOwner);
	atmowner = MSBankingATM(compOwner);

	balanceModifier = atmowner.GetBalance(GuysIP, 0.000000);
	UpdateBalance();

		test = InstructionText;

	winInstructions.SetText(test);

//	EnableButtons();
	SetFocusWindow(editWithdraw);
}

// ----------------------------------------------------------------------
// UpdateBalance()
// ----------------------------------------------------------------------

function UpdateBalance()
{
        local string GuysIP;
        local int i;

	GuysIP = Player.GetPlayerNetworkAddress();
	GuysIP = Left(GuysIP, InStr(GuysIP, ":"));

        i = atmowner.GetBalance(GuysIP, 0.000000);

	balanceModifier = i;

		editBalance.SetText(String(balanceModifier));
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	switch( buttonPressed )
	{
		case btnWithdraw:
			WithdrawCredits();
			break;

		case btnDeposit:
			DepositCredits();
			break;

		case btnClose:
                        CloseScreen("LOGOUT");
                        //atmowner.atmwindow = None;
			break;

		default:
			bHandled = False;
			break;
	}

	if (bHandled)
		return True;
	else
		return Super.ButtonActivated(buttonPressed);
}


// ----------------------------------------------------------------------
// WithdrawCredits()
// ----------------------------------------------------------------------

function DepositCredits()
{
	local int numCredits;
	local int balance;
        local string GuysIP;

	GuysIP = Player.GetPlayerNetworkAddress();
	GuysIP = Left(GuysIP, InStr(GuysIP, ":"));

	numCredits = float(editWithdraw.GetText());

	// deposit
	if (numCredits > 0)
	{
		if (player.credits >= numCredits)
		{
				atmOwner.AModBalance(GuysIP, numCredits, True);

			player.Credits -= numCredits;
			winInfo.SetText(String(numCredits) @ CreditsDepositedLabel);

		}
		else
		{
			winInfo.SetText(InsufficientCreditsLabel);
		}
	}
	else
	{
		winInfo.SetText(InvalidAmountLabel);
	}

	// Blank withdraw box and reset focus to that window
	editWithdraw.SetText("");
	UpdateBalance();
	SetFocusWindow(editWithdraw);
}

function WithdrawCredits()
{
	local int numCredits;
	local int balance;
        local string GuysIP;

	GuysIP = Player.GetPlayerNetworkAddress();
	GuysIP = Left(GuysIP, InStr(GuysIP, ":"));

	numCredits = Int(editWithdraw.GetText());

	// withdrawal
	if (numCredits > 0)
	{
			balance = atmOwner.GetBalance(GuysIP, balanceModifier);

		if (balance >= numCredits)
		{
				atmOwner.SModBalance(GuysIP, numCredits, True);

			player.Credits += numCredits;
			winInfo.SetText(String(numCredits) @ CreditsWithdrawnLabel);
		}
		else
		{
			winInfo.SetText(InsufficientCreditsLabel);
		}
	}
	else
	{
		winInfo.SetText(InvalidAmountLabel);
	}

	// Blank withdraw box and reset focus to that window
	editWithdraw.SetText("");
	UpdateBalance();
	SetFocusWindow(editWithdraw);
}

// ----------------------------------------------------------------------
// TextChanged() 
// ----------------------------------------------------------------------

/*event bool TextChanged(window edit, bool bModified)
{
	EnableButtons();

	return False;
}*/

// ----------------------------------------------------------------------
// EnableButtons()
// ----------------------------------------------------------------------

/*function EnableButtons()
{
	local float balance;
        local string GuysIP;

	GuysIP = Player.GetPlayerNetworkAddress();
	GuysIP = Left(GuysIP, InStr(GuysIP, ":"));

	// Only allow withdraw if there's money to be withdrawn and the user has typed
	// something into the editWithdraw field

		balance = atmOwner.GetBalance(GuysIP, balanceModifier);

	btnWithdraw.SetSensitivity((editWithdraw.GetText() != "") && (balance > 0));
}*/

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     disabledDelay=5.000000
     ButtonLabelDeposit="|&Deposit"
     ButtonLabelWithdraw="|&Withdraw"
     ButtonLabelClose="|&Close"
     BalanceLabel="Current Balance:"
     WithdrawAmountLabel="Amount to Modify:"
     InstructionText="Account: |nPlease enter the amount of|nDollars you wish to withdraw."
     InvalidAmountLabel="INVALID AMOUNT ENTERED"
     InsufficientCreditsLabel="INSUFFICIENT DOLLARS"
     CreditsWithdrawnLabel="DOLLARS WITHDRAWN"
     CreditsDepositedLabel="DOLLARS DEPOSITED"
     StatusText="lolwut.roflcopter/nubhax!nowaiXDROFLMAOWTF"
     escapeAction="LOGOUT"
     Title="Markistan Banking System"
     ClientWidth=403
     ClientHeight=211
     verticalOffset=30
     clientTextures(0)=Texture'DeusExUI.UserInterface.ComputerGBSWithdrawBackground_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.ComputerGBSWithdrawBackground_2'
     textureRows=1
     textureCols=2
     bAlwaysCenter=True
     statusPosY=186
     ComputerNodeFunctionLabel="ATMWD"
}
